//Program to find out transient stability analysis of single machine - infinite bus system //
//An example problem and outputs are available in files 'result1' and 'result2'
//Scilab Version 5.5.2 ; OS:Windows

clc;
clear;

xd=0.3;

theta=acos(0.8);                               //Power factor angle

S=(0.5/0.8)*cos(theta)+%i*sin(theta);          // Apparant Power
V=1;                                           //  Prefault vltage is assumed to be 1 pu
Ia=(conj(S)/V);                                 // Pefault steady state current

E=V+(%i*xd)*(Ia);                              //Voltage behind transient reactance

disp(E,'The voltage behind transient reactance in pu is ')

//To find the power angle curve

delta=0:0.001:%pi;
P=((E*V)/xd)*(sin(delta));

plot(delta,P)
xlabel('delta in radians')
ylabel('Power in pu')
title('Power angle curve')
